/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.security.JameicaSecurityManager;
import de.willuhn.logging.Logger;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SecurityManagerService
implements Bootable {
    private static final List<String> props = Arrays.asList("java.version", "java.specification.version", "java.runtime.version", "java.vm.specification.version", "java.vm.version");
    private JameicaSecurityManager securityManager = null;

    public Class[] depends() {
        return null;
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        this.securityManager = new JameicaSecurityManager();
        int jv = this.getJavaVersion();
        Logger.info((String)("detected java version: " + jv));
        if (jv >= 18) {
            Logger.info((String)"running in java version 18 or higher, security manager no longer available");
            return;
        }
        Logger.info((String)"applying jameica security manager");
        System.setSecurityManager(this.securityManager);
    }

    private int getJavaVersion() {
        Integer i = null;
        for (String s : props) {
            i = this.parseInt(System.getProperty(s));
            if (i == null) continue;
            return i;
        }
        Logger.warn((String)"unable to determine java version");
        return 0;
    }

    private Integer parseInt(String s) {
        int dot;
        int plus;
        if ((s = StringUtils.trimToNull((String)s)) == null) {
            return null;
        }
        int minus = s.indexOf(45);
        if (minus > 0) {
            s = s.substring(0, minus);
        }
        if ((plus = s.indexOf(43)) > 0) {
            s = s.substring(0, plus);
        }
        if ((dot = s.indexOf(46)) > 0) {
            s = s.substring(0, dot);
        }
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            Logger.error((String)("unable to parse " + s + " as numeric java version"), (Throwable)e);
            return null;
        }
    }

    public JameicaSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void shutdown() {
        this.securityManager = null;
    }
}

